<!doctype html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Book Your Cottages | Book Rooms at Sakleshpur Resorts</title>
    <meta name="description" content="Bookings Open for Home-stay, Cottages &amp; Rooms at Resort in Sakleshpur. Enter Basic Details & Select Cottage, Find the Check-in & Check-out Timings">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!----------------links--------------------->
    <link rel="canonical" href="https://mookanana.com/booknow.php">
    <link rel="icon" type="image/png" sizes="32x32" href="images/favicon-32x32.png">

    <!-----------------bootstrap--------------->
    <?php include "common/style.php";?>
    <link rel="stylesheet" href="css/material-bootstrap-wizard.css">

<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-T67L36C');</script>
<!-- End Google Tag Manager -->


<!-- <script type="application/ld+json">
            {
                "@context": "http://schema.org",
                "@type": "Product",
                "description": "Bookings Open for Home-stay, Cottages &amp; Rooms at Resort in Sakleshpur. Visit https://mookanana.com/booknow.php & Select Cottage, Find the Check-in & Check-out Timings",
                "name": "Hotels & Resorts in Sakleshpur",
                "url": "https://mookanana.com/booknow.php",
                "aggregateRating": {
                    "@type": "AggregateRating",
                    "ratingValue": "5",
                    "reviewCount": "140"
                }
            }
</script> -->

</head>

<body>

<?php

include "common/menu.php";

//
//if(isset($_POST['submit'])){
//$_checkin = $_POST['arrivalDate'];
//}






//get the list
$availableCottages = $availableCottage->listAll();

// var_dump($availableCottages);

//mallige cottages available
 $mallige = $availableCottages[0];
$malligevalues = $mallige['available'];

$corpvalues = 50;
//sampige cottages available
$sampige = $availableCottages[1];
$sampigevalues = $sampige['available'];
//var_dump($sampigevalues);

//parijatha cottages available
$parijatha = $availableCottages[2];
$parijathavalues = $parijatha['available'];

//var_dump($malligevalues);
//var_dump($sampigevalues);
//var_dump($parijathavalues);
//exit;

//$totalCottages = $malligevalues + $sampigevalues + $parijathavalues;
//if($totalCottages>)

$visitors = $visitor->listAllAdmissions();
//
//var_dump($visitors);
//exit;

$BookingDetails = new \stdClass();
$BookingDetails->id = '';
$BookingDetails->CottageTypeMallige = 0;
$BookingDetails->CottageTypeSampige =0;
$BookingDetails->CottageTypeParijatha = 0;
$BookingDetails->ArrivalDate = '';
$BookingDetails->DepartureDate = '';
$BookingDetails->Couple = 0;
$BookingDetails->CostForCouple = 0;
$BookingDetails->AdultsWithCouple = 0;
$BookingDetails->CostForAdultsWithCouple = 0;
$BookingDetails->KidsWithCouple = 0;
$BookingDetails->CostForKidsWithCouple = 0;
$BookingDetails->CorporateStags = 0;
$BookingDetails->CostForCorporateStags = 0;
$BookingDetails->KidsWithCorporateStags = 0;
$BookingDetails->CostForKidsWithCorporateStags = 0;
$BookingDetails->Duration = 0;
$BookingDetails->Total = 0;


foreach($prices as $key => $value) {

    if($value['visitors_type'] == "Couple") {

        $BookingDetails->CostForCouple = $value['price'];

    } else if($value['visitors_type'] == "Adults[withCouple]") {

        $BookingDetails->CostForAdultsWithCouple = $value['price'];

    }
    else if($value['visitors_type'] == "kids[withCouple]") {

        $BookingDetails->CostForKidsWithCouple = $value['price'];

    }
    else if($value['visitors_type'] == "CorporateStags[individuals]") {

        $BookingDetails->CostForCorporateStags = $value['price'];

    }
    else if($value['visitors_type'] == "kids[corporateStags]"){

       $BookingDetails->CostForKidsWithCorporateStags = $value['price'];

    }
}


$sid = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

$form_action = $sid ? 'update' : 'create';

$visitor = [
    'id' => '',
    'name' => '',
    'email' => '',
    'phone' => ''
];

$current_action = filter_input(INPUT_GET, 'action', FILTER_SANITIZE_STRING);
//saving new book

function create($data) {

    // $data = $_POST;
//    var_dump($data);exit();

    if (isset($_POST['name']) && isset($_POST['phone'])) {

        if ($visitor->add($data)) {
            header('Location:booknow.php');
            exit;
        }

        $visitor = $data;
    }
     
 } ?>
<section class="banner">
    <div class="container">
        <div class="">
            <h1 class="top-trek">Book Your Cottages</h1>
            <ul class="breadcrumb my-bg">

                <ol class="breadcrumb my-bg" itemscope itemtype="http://schema.org/BreadcrumbList">
                    <li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"><a itemprop="item" href="index.php" class="resort-home"><span
                                    itemprop="name"  >Mookanana Resort <i class="fas fa-angle-double-right"></i></span></a>
                        <meta itemprop="position" content="1"/>
                    </li>

                    <li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"><a itemprop="item" href="https://live.ipms247.com/booking/book-rooms-mookananresort" target="_blank" class="link-color"><span
                                    itemprop="name">Book Resorts in Sakleshpur</span></a>
                        <meta itemprop="position" content="2"/>
                    </li>
                </ol>
            </ul>
        </div>
    </div>
</section>
<section class="mybook-bg gallary">
         <!--   Big container   -->
            <div class="container mypos">
                <div class="row">
                    <div class="col-sm-12">
                        <!--      Wizard container        -->
                        <div class="wizard-container">
                            <div class="card wizard-card" data-color="red" id="wizard">

                                    <div class="wizard-header">
                                        <h3 class="wizard-title">
                                            Book a cottage
                                        </h3>
                                        <h5>This information will let us know more about you.</h5>
                                    </div>
                                    <div class="wizard-navigation" id="tabs">
                                        <ul>
                                            <li><a href="#details" data-toggle="tab">Basic Instructions</a></li>
                                            <li><a href="#book" data-toggle="tab">Select cottage</a></li>
                                            <li><a href="#description" data-toggle="tab">Billing Info</a></li>


                                        </ul>
                                    </div>
                                     
                                    <div class="tab-content">

                         <!----------------------1st step instructions details------------------------->
                                    <div class="tab-pane mybook-bdr" id="details">

                     <div class="mybook-bdr clearfix pad-10">


                                        <div class="row">

                                            <div class="col-xs-12 col-md-4 col-sm-4">
                                                <div class="room-stay room-stay1">

                                                    <p class="about-room-heading"> Mallige cottage</p>
                                                    <p><span class="max-stay">Maximum Stay:</span>  <span class="category">5 Adults + 2 Kids</span> </p>
                                                    <p><span class="max-stay">Minimum Stay:</span>  <span class="category">2 Adults</span> </p>
                                                    <ul class="list-inline">
                                                        <li><a data-toggle="tooltip" data-placement="top" title="" data-original-title="Free wifi"> <i class="fa fa-wifi" aria-hidden="true"></i></a></li>
                                                        <li><a data-toggle="tooltip" data-placement="top" title="" data-original-title="Air conditioner">  <i class="fa fa-snowflake-o" aria-hidden="true"></i></a></li>
                                                        <li><a data-toggle="tooltip" data-placement="top" title="" data-original-title="room service"> <i class="fa fa-bell" aria-hidden="true"></i></a></li>
                                                        <li><a data-toggle="tooltip" data-placement="top" title="" data-original-title="free breakfast">  <i class="fas fa-coffee"></i></a></li>
                                                    </ul>

                                                </div>
                                            </div>
                                            <div class="col-xs-12 col-md-4 col-sm-4">
                                                <div class="room-stay room-stay1">

                                                    <p class="about-room-heading"> Sampige cottage</p>
                                                    <p><span class="max-stay">Maximum Stay:</span>  <span class="category">7 Adults + 2 Kids</span> </p>
                                                    <p><span class="max-stay">Minimum Stay:</span>  <span class="category">2 Adults</span> </p>
                                                    <ul class="list-inline">
                                                        <li><a data-toggle="tooltip" data-placement="top" title="" data-original-title="Free wifi"> <i class="fa fa-wifi" aria-hidden="true"></i></a></li>
                                                        <li><a data-toggle="tooltip" data-placement="top" title="" data-original-title="Air conditioner">  <i class="fa fa-snowflake-o" aria-hidden="true"></i></a></li>
                                                        <li><a data-toggle="tooltip" data-placement="top" title="" data-original-title="room service"> <i class="fa fa-bell" aria-hidden="true"></i></a></li>
                                                        <li><a data-toggle="tooltip" data-placement="top" title="" data-original-title="free breakfast">  <i class="fas fa-coffee"></i></a></li>
                                                    </ul>

                                                </div>
                                            </div>
                                            <div class="col-xs-12 col-md-4 col-sm-4">
                                                <div class="room-stay room-stay1">

                                                    <p class="about-room-heading"> Parijatha Villa</p>
                                                    <p><span class="max-stay">Maximum Stay:</span>  <span class="category">10 Adults + 4 Kids</span> </p>
                                                    <p><span class="max-stay">Minimum Stay:</span>  <span class="category">6 Adults</span> </p>
                                                    <ul class="list-inline">
                                                        <li><a data-toggle="tooltip" data-placement="top" title="" data-original-title="Free wifi"> <i class="fa fa-wifi" aria-hidden="true"></i></a></li>
                                                        <li><a data-toggle="tooltip" data-placement="top" title="" data-original-title="Air conditioner">  <i class="fa fa-snowflake-o" aria-hidden="true"></i></a></li>
                                                        <li><a data-toggle="tooltip" data-placement="top" title="" data-original-title="room service"> <i class="fa fa-bell" aria-hidden="true"></i></a></li>
                                                        <li><a data-toggle="tooltip" data-placement="top" title="" data-original-title="free breakfast">  <i class="fas fa-coffee"></i></a></li>
                                                    </ul>

                                                </div>
                                            </div>




                                        </div>

                         <div class="row">
                             <div class="ftr-p">
                                 <p>Note:</p>
                                 <?php foreach($prices as $price) : ?>
                                     <p>* <?= $price['visitors_type'] ?><span class="mypad"> - <i class="fa fa-inr" aria-hidden="true"></i><?= $price['price'] ?></span></p>
                                 <?php endforeach; ?>
                                 <p>*Rates depends on Couples and Corporate Groups</p>
                                 <p>*At One cottage Five members can be allocated For Corporate groups</p>
                                 <p>*Childrens above 6yrs Will be charged</p>

                                 <p>*For Enquiry and special offers please call <a href="tel:7338000666" class="my-color">7338000666</a></p>
                             </div>
                         </div>
                                       <div class="wizard-footer">
                                                <div class="pull-right">
<!--                                                    <button type="submit"  class='btn btn-next btn-fill btn-danger btn-wd' onclick="save_data()"  value='Next'>Next</button>-->
                                                    <input type='button' class='btn btn-next btn-fill btn-danger btn-wd'   value='Next' />
                                                </div>
                                                <div class="pull-left">
                                                    <input type='button' class='btn btn-previous btn-fill btn-default btn-wd' name='previous' value='Previous' />


                                                </div>

                                                <div class="clearfix"></div>


                                    </div>

                     </div>

                                    </div>




                                        <!-------------------2nd step Select room section --------------------->
                                        <div class="tab-pane" id="book">
                                            <div class="mybook-bdr clearfix">

                                                <form class="dynamic-bdr text-center clearfix" id="myform1"  method="post" accept-charset="utf-8">


                                                            <div class="row">
                                                                <div class="form-group clearfix form-inline">
                                                                    <label class="col-md-3 col-sm-3 col-lg-3 col-xs-12 control-label mylbl">Date range</label>

                                                                    <div class="col-md-4 col-sm-4 col-lg-4 col-xs-12 text-left">
                                                                        <div class="input-group date" data-provide="datepicker">
                                                                            <span class="input-group-addon"><i class="far fa-calendar-alt"></i></span>
                                                                            <input  type="text" class="form-control" id="arrivalDate" name="arrivalDate" placeholder="Arrival Date" required>
                                                                            <p class="error" id="error-arrive">*please select Arrivial Date</p>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-4 col-sm-4 col-lg-4 col-xs-12 text-left">
                                                                        <div class="input-group date" data-provide="datepicker">
                                                                            <span class="input-group-addon"><i class="far fa-calendar-alt"></i></span>
                                                                            <input  type="text" class="form-control"  id="departureDate" name="departureDate"  placeholder="Departure Date" required>
                                                                            <p class="error" id="error-dept">*please select Departure Date</p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="row">
                                                                <div class="form-group clearfix form-inline">
                                                                    <div class="col-md-3 col-sm-3 col-lg-3 col-xs-12">
                                                                        <label class=" control-label mylbl">Select Type</label>
                                                                         <p class="error" id="pls-select">*please select your required category</p>
                                                                    </div>
                                                                    <div class="pad-10">
                                                                        <div class="col-md-4 col-sm-4 col-lg-4 col-xs-12 text-left">
                                                                            <div id="#corprate"> <input  name="selecttype" id="corprate" type="radio">
                                                                                <label for="corprate">Corporate Stags or Individual Adults</label>

                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-4 col-sm- col-lg-4 col-xs-4 text-left">
                                                                            <div id="#family">
                                                                                <input  name="selecttype"  id="family"  type="radio" >
                                                                                <label for="family">Family</label>
                                                                            </div>
                                                                        </div>

                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div id="selectOpt">

                                                                <div  class="row" id="selectcorp">
                                                                    <div   class="form-group clearfix form-inline" >
                                                                        <div class="col-md-3 col-sm-3 col-lg-3 col-xs-12">
                                                                      </div>
                                                                        <div class="col-md-9 col-sm-9 col-lg-9 col-xs-12 control-label mylbl">

                                                                            <div class="display-flex">
                                                                                <div class="col-md-4 text-left col-sm-4 col-lg-4 col-xs-12 text-left">
                                                                                    <p>Adults</p>
                                                                                </div>
                                                                                <div class="col-md-4 col-sm-4 text-left col-lg-4 col-xs-12">
                                                                                    <div class="input-group">
                                                                                        <span class="input-group-addon"><i class="fas fa-user mysiz"></i> x</span>
                                                                                        <select class= "form-control" required  name="isCorp" id="isCorp">
                                                                                            <option value="0">--Select--</option>

                                                                                            <?php for($i=1 ; $i<=(int)$corpvalues; $i++) :

                                                                                                echo "<option value=$i>$i</option>";


                                                                                            endfor; ?>
                                                                                        </select>
                                                                                        <p  class=" error" id="error-select1">*please select</p>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="display-flex">
                                                                                <div class="col-md-4 text-left col-sm-4 col-lg-4 col-xs-12">
                                                                                    <p> kids</p>
                                                                                </div>
                                                                                <div class="col-md-4 col-sm-4 text-left col-lg-4 col-xs-12">
                                                                                    <div class="input-group">
                                                                                        <span class="input-group-addon"><i class="fas fa-child"></i>x</span>
                                                                                        <select class= "form-control"  name="isCorpkids" id="isCorpkids">
                                                                                            <option value="0">--select--</option>
                                                                                            <option value="1">1</option>
                                                                                            <option value="2">2</option>
                                                                                            <option value="3">3</option>
                                                                                            <option value="4">4</option>
                                                                                            <option value="5">5</option>
                                                                                            <option value="6">6</option>
                                                                                        </select>
                                                                                        <span class="input-group-addon">  <a data-toggle="tooltip" data-placement="top" title="" data-original-title="Kids above 6yrs to 12yrs">  <i class="fas fa-question-circle"></i></a></span>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row" id="selectfamily" >
                                                                    <div  class="form-group clearfix form-inline">
                                                                        <div class="col-md-3 col-sm-3 col-lg-3 col-xs-12">
                                                                            <!--                                                    <label class=" control-label mylbl">For Family</label>--></div>
                                                                        <div class="col-md-9 col-sm-9 col-lg-9 col-xs-12 control-label mylbl" id="select">
                                                                            <div class="display-flex">
                                                                                <div class="col-md-4 text-left col-sm-4 col-lg-4 col-xs-12">
                                                                                    <p class="text-left">couples</p>
                                                                                </div>
                                                                                <div class="col-md-4 col-sm-4 col-lg-4 col-xs-12">
                                                                                    <div class="input-group">
                                                                                        <span class="input-group-addon"><i class="fas fa-user-friends mysiz"></i> x</span>
                                                                                        <select class= "form-control" name="isCouple" id="isCouple">
                                                                                            <option value="0">--Select--</option>
                                                                                            <option value="1">1</option>
                                                                                            <option value="2">2</option>
                                                                                            <option value="3">3</option>
                                                                                            <option value="4">4</option>
                                                                                            <option value="5">5</option>
                                                                                            <option value="6">6</option>
                                                                                            <option value="7">7</option>
                                                                                            <option value="8">8</option>
                                                                                            <option value="9">9</option>
                                                                                            <option value="10">10</option>

                                                                                        </select>
                                                                                        <p  class="error" id="error-select2">*please select</p>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="display-flex">
                                                                                <div class="col-md-4 text-left col-sm-4 col-lg-4 col-xs-12">
                                                                                    <p class="text-left"> Adults (extra with couples)</p>
                                                                                </div>
                                                                                <div class="col-md-4 col-sm-4 col-lg-4 col-xs-12">
                                                                                    <div class="input-group">
                                                                                        <span class="input-group-addon"><i class="fas fa-user mysiz"></i> x</span>
                                                                                        <select class= "form-control"  name="isfamilyAdult" disabled id="isfamilyAdult" >
                                                                                            <option value="0">--Select--</option>
                                                                                            <option value="1">1</option>
                                                                                            <option value="2">2</option>
                                                                                            <option value="3">3</option>
                                                                                            <option value="4">4</option>
                                                                                            <option value="5">5</option>
                                                                                            <option value="6">6</option>
                                                                                            <option value="7">7</option>
                                                                                            <option value="8">8</option>
                                                                                            <option value="9">9</option>
                                                                                            <option value="10">10</option>
                                                                                            <option value="11">11</option>
                                                                                            <option value="12">12</option>
                                                                                            <option value="13">13</option>
                                                                                            <option value="14">14</option>
                                                                                            <option value="15">15</option>
                                                                                            <option value="16">16</option>
                                                                                            <option value="17">17</option>
                                                                                            <option value="18">18</option>
                                                                                            <option value="19">19</option>
                                                                                            <option value="20">20</option>
                                                                                        </select>
                                                                                        <span class="input-group-addon">  <a data-toggle="tooltip" data-placement="top" title="" data-original-title="please select couple to select Adults or go to individuals">  <i class="fas fa-question-circle"></i></a></span>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="display-flex">
                                                                                <div class="col-md-4 text-left col-sm-4 col-lg-4 col-xs-12">
                                                                                    <p class="text-left"> kids</p>
                                                                                </div>
                                                                                <div class="col-md-4 col-sm-4 col-lg-4 col-xs-12">
                                                                                    <div class="input-group">
                                                                                        <span class="input-group-addon"><i class="fas fa-child"></i>x</span>
                                                                                        <select class= "form-control"  name="isCoupleKids" id="isCoupleKids"  disabled>
                                                                                            <option value="0">--select--</option>
                                                                                            <option value="1">1</option>
                                                                                            <option value="2">2</option>
                                                                                            <option value="3">3</option>
                                                                                            <option value="4">4</option>
                                                                                            <option value="5">5</option>
                                                                                            <option value="6">6</option>
                                                                                        </select>
                                                                                        <span class="input-group-addon">  <a data-toggle="tooltip" data-placement="top" title="" data-original-title="Kids above 6yrs to 12yrs">  <i class="fas fa-question-circle"></i></a></span>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div >

                                                            </div>

                                                           <div class="row">
                                                            <div class="form-group clearfix form-inline">
                                                                <div class="col-md-3 col-sm-3 col-lg-3 col-xs-12 ">
                                                                <label  class="control-label mylbl ">select Cottage</label>
                                                                    <p class="error error-rooms">*Please select available cottages</p>
                                                                </div>

                                                                    <div class="col-md-4 col-sm-4 col-lg-4 col-xs-12 text-left">
                                                                        <p class="control-label mylbl pad-10">Mallige Cottage</p>
                                                                    </div>
                                                                    <div class="col-md-4 col-sm-4 col-lg-4 text-left col-xs-12">
                                                                        <div class="input-group" style="width: 100%;">
                                                                            <select class= "form-control mysel cottage-selected" id="mallige" required  name="mallige">
                                                                                <option value="0">--Select available Cottages--</option>

                                                                                <?php for($i=1 ; $i<=(int)$malligevalues; $i++) :

                                                                                    echo "<option value=$i>$i</option>";


                                                                                endfor; ?>

                                                                            </select>
                                                                        </div>
                                                                    </div>

                                                            </div>

                                                        </div>

                                                          <div class="row">
                                                                    <div class="form-group clearfix form-inline">
                                                                    <div class="col-md-3 col-sm-3 col-lg-3 col-xs-12"></div>
                                                            <div class="col-md-4 col-sm-4 text-left col-lg-4 col-xs-12">
                                                                <p class="control-label mylbl pad-10">Sampige Cottage</p>
                                                            </div>
                                                            <div class="col-md-4 col-sm-4 text-left col-lg-4 col-xs-12">
                                                                <div class="input-group" style="width: 100%;">
                                                                    <select class= "form-control mysel cottage-selected" id="sampige" required  name="sampige">
                                                                        <option value="0">--Select available Cottages--</option>
                                                                        <?php for($i=1 ; $i<=(int)$sampigevalues; $i++) :

                                                                            echo "<option value=$i>$i</option>";


                                                                         endfor; ?>


                                                                    </select>
                                                                </div>
                                                            </div>
                                                                    </div>
                                                                </div>

                                                         <div class="row">
                                                                <div class="form-group clearfix form-inline">
                                                                <div class="col-md-3 col-sm-3 col-lg-3 col-xs-12"></div>
                                                                <div class="col-md-4 col-sm-4 text-left col-lg-4 col-xs-12">
                                                                    <p class="control-label mylbl pad-10">Parijatha cottage</p>
                                                                </div>
                                                                <div class="col-md-4 col-sm-4 text-left col-lg-4 col-xs-12">
                                                                    <div class="input-group" style="width: 100%;">
                                                                        <select class= "form-control mysel cottage-selected" id="parijatha"   required name="parijatha">
                                                                            <option value="0">--Select available Cottages--</option>

                                                                            <?php for($i=1 ; $i<=(int)$parijathavalues; $i++) :

                                                                                echo "<option value=$i>$i</option>";


                                                                            endfor; ?>

                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                </div>
                                                            </div>



                                                              <div class="row pad-10">
                                                        <div class="wizard-footer">
                                                            <div class="pull-right">
                                                                <input type='button' class='btn btn-next btn-fill btn-danger btn-wd' id="booknow"  value='Book Now'/>
<!--                                                                <input type="submit" name="submit" class='btn btn-next btn-fill btn-danger btn-wd'  value='Book Now'/>-->
                                                            </div>
                                                            <div class="pull-left">
                                                                <input type='button' class='btn btn-previous btn-fill btn-default btn-wd' name='previous' value='Previous' />

                                                            </div>
                                                            <div class="clearfix"> </div>

                                                        </div>
                                                    </div>
                                                    <p class="error" id="errormsg">*please select required fields to continue further</p>
                                                </form>
                                                </div>












                                               



                                                <div class="other-booking clearfix">
                                                    <h3 class="text-center text-uppercase">Other booking options</h3>
                                                    <div class="col-md-2 col-sm-2">
                                                        <a href="https://www.tripadvisor.in/Hotel_Review-g2371802-d14996443-Reviews-Mookanana_Resort-Sakleshpur_Hassan_District_Karnataka.html" target="_blank"><img src="img/Sakleshpur-Resorts-Homestays/partners/goibibo.png" class="img-responsive" alt="goibibo" title="goibibo.com">  </a>
                                                    </div>
                                                    <div class="col-md-2 col-sm-2">
                                                        <a href="https://www.makemytrip.com/hotels/mookaanana_resort-details-sakleshpur.html" target="_blank"><img src="img/Sakleshpur-Resorts-Homestays/partners/mmtlogo.png" class="img-responsive" alt="makemytrip-MMT" title="MakeMyTrip.com">  </a>
                                                    </div>
                                                    <div class="col-md-2 col-sm-2">
                                                        <a href="https://www.tripadvisor.in/Hotel_Review-g2371802-d14996443-Reviews-Mookanana_Resort-Sakleshpur_Hassan_District_Karnataka.html" target="_blank"><img src="img/Sakleshpur-Resorts-Homestays/partners/tripadvisor.png" class="img-responsive" alt="tripadvisor" title="TripAdvisor.com">  </a>
                                                    </div>
                                                    <div class="col-md-2 col-sm-2">
                                                        <a href="https://www.yatra.com/hotels/hotels-in-sakleshpur/mookanana-resort" target="_blank"><img src="img/Sakleshpur-Resorts-Homestays/partners/yatra.png" class="img-responsive" alt="yatra" title="Yatra.com">  </a>
                                                    </div>
                                                </div>

                                        </div>



                                        <!-----3rd step final step------>
                                       <div class="tab-pane" id="description">
                                           <div class="mybook-bdr clearfix">


                                            <div class="row">
                                                <div class="clearfix">
                                                    <div class="col-md-2 col-lg-2"></div>
                                                    <div class="col-md-8 col-lg-8">
                                                        <h4 class="welcome-heading mar-top-3">Booking Summary </h4>
                                                        <div class="">
                                                            <table class="table table-responsive table-bordered">
                                                                <tbody>
                                                                <tr>
                                                                    <th>Check In:</th>
                                                                    <td><span id="checkindis"></span></td>

                                                                </tr>
                                                                <tr>
                                                                    <th>Check Out:</th>
                                                                    <td><span id="checkoutdis"></span></td>

                                                                </tr>
                                                                <tr>
                                                                    <th>Number of days:</th>
                                                                    <td><span id="durationdis"></span></td>

                                                                </tr>
                                                                <tr>
                                                                    <th>Couples:</th>
                                                                    <td><span id="coupledis"></span></td>

                                                                </tr>
                                                                <tr>
                                                                    <th>Adults(with couples):</th>
                                                                    <td><span id="coupleadultdis"></span></td>

                                                                </tr>
                                                                <tr>
                                                                    <th>kids(with couples):</th>
                                                                    <td><span id="couplekidsdis"></span></td>

                                                                </tr>
                                                                <tr>
                                                                    <th>corporate stags[individual adults]:</th>
                                                                    <td><span id="corpdis"></span></td>

                                                                </tr>
                                                                <tr>
                                                                    <th>kids[with individual adults]:</th>
                                                                    <td><span id="corpkidsdis"></span></td>

                                                                </tr>
                                                                <tr>
                                                                    <th>Cottage selected:</th>
                                                                    <td>Mallige = <span id="cottagetypemalli"></span> , Sampige= <span id="cottagetypesampi"></span>  , Parijatha = <span id="cottagetypepari"></span></td>

                                                                </tr>

                                                                <tr>
                                                                    <th>Total Fare:</th>
                                                                    <td>Rs.<span id="totaldis"></span>/-</td>

                                                                </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>

                                                    </div>
                                                    <div class="col-md-2 col-lg-2"></div>
                                            </div>

                                            </div>

                                                <div class="row">
                                                    <form class="book-outerform form" action="pay.php" method="post" accept-charset="utf-8">
                                                        <input type="hidden" name="id" id="id" value="">
                                                        <input type="hidden" name="finalArrvial" id="finalArrvial" value="">
                                                        <input type="hidden" name="finalDeparture" id="finalDeparture" value="">
                                                        <input type="hidden" name="finalDays" id="finalDays" value="">

                                                        <input type="hidden" name="finalCouples" id="finalCouples" value="">
                                                        <input type="hidden" name="finalCoupleAdults" id="finalCoupleAdults" value="">
                                                        <input type="hidden" name="finalCoupleKids" id="finalCoupleKids" value="">

                                                        <input type="hidden" name="finalCorporate" id="finalCorporate" value="">
                                                        <input type="hidden" name="finalCorporateKids" id="finalCorporateKids" value="">
                                                        <input type="hidden" name="finalPrice" id="finalPrice" value="">
                                                    <div class="clearfix">
                                                        <div class="col-md-2 col-lg-2"></div>
                                                          <div class="col-md-8">
                                                              <h4 class="welcome-heading mar-top-3">Personal Details </h4>
                                                              <div class="form-group show-inlineform">
                                                <label for="usr">Name:</label>
                                                <input name="firstName" type="text" class="form-control mybook-entry" id="usr" required>
                                            </div>
                                            <div class="form-group show-inlineform">
                                                <label for="eml">Email:</label>
                                                <input name ="email" type="email" class="form-control mybook-entry" id="eml" required>
                                            </div>
                                            <div class="form-group show-inlineform">
                                                <label for="call">Phone:</label>
                                                <input name="phone" type="number" class="form-control mybook-entry" id="call" required>
                                            </div>

                                            </div>
                                                        <div class="col-md-2 col-lg-2"></div>
                                                      </div>
                                                        <div class="wizard-footer">
                                                            <div class="pull-right">

                                                                    <input  type="submit" class='btn btn-danger' name="pay"  id="pay" value='Pay'/>


                                                            </div>
                                                            <div class="pull-left">
                                                                <input type='button' class='btn btn-previous btn-fill btn-default btn-wd' name='previous' value='Previous' />

                                                            </div>
                                                        </div>
                                                    </form>

                                            </div>


                                            <div class="ftr-p" id="toggle" style="display:none;">
                                               <p id="bid"></p>
                                            </div>




                                        
                                    </div>



                            </div>
                        </div> <!-- wizard container -->
                    </div>
                </div> <!-- row -->
            </div> <!--  big container -->

                </div>
            </div>




</section>


<?php include "common/footer.php";?>

<!-------------------------------------------->
<?php include "common/script.php";?>
<script src="js/jquery.bootstrap.js"></script>
<!--<script src="js/material-bootstrap-wizard.js"></script>-->
<script src="js/jquery.validate.min.js"></script>
<!-- <script src="node_modules/moment/moment.js"></script> -->

<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T67L36C"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->

</body>
<script>
    var bookingDetails = <?php echo json_encode($BookingDetails); ?>;




    $('#arrivalDate').on('change',function(e) {

        if(this.value){
            localStorage.setItem("checkarrive",this.value)
            $('#error-arrive').text('');
        }
        else if(this.value === ""){
            $('#error-arrive').text('*please select Arrivial Date');

        }
    });

    $('#departureDate').on('change',function(e) {
        if(this.value){
            localStorage.setItem("checkdept",this.value)
            $('#error-dept').text('');
        }
        else if(this.value === ""){
            $('#error-dept').text('*please select Departure Date');

        }
    });

    $('#isCorp').on('change',function(e) {
        var checkcorp = $("#isCorp option:selected").val();

if( checkcorp > "0" ){
            $('#error-select1').text('');
            localStorage.setItem("checkcorp", checkcorp);

        }

        else  if( checkcorp === "0" )  {

            $('#errormsg').text('*Please Fill Required Fields');
            $('#error-select1').text('*please select');

        }

    });


    $('#isCouple').on('change',function(e) {
        var family = $("#isCouple option:selected").val();

        if (family > "0") {

            $('#isfamilyAdult').removeAttr('disabled');
            localStorage.setItem("checkcouple", family);
            $('#isCoupleKids').removeAttr('disabled');
            $('#error-select2').text('');

        }
        else if(family === "0"){
            $('#isfamilyAdult').prop('disabled','true');
            document.getElementById('isfamilyAdult').selectedIndex = 0;

            $('#isCoupleKids').prop('disabled','true');
            document.getElementById('isCoupleKids').selectedIndex = 0;

            $('#error-select2').text('*please select');



            $('#errormsg').text('*Please Fill Required Fields');

        }

    });


    $('#mallige').on('change',function(){
        var mallige  = $("#mallige option:selected").val();
        if(mallige > "0"){
            $('.error-rooms').text('');
            $('#errormsg').text('');
        }
        else if (mallige === "0"){
            $('.error-rooms').text('*Please Select Available Cottages');

            $('#errormsg').text('*please select required fields to continue further');
        }


    });
    $('#sampige').on('change',function(){
        var sampige = $("#sampige option:selected").val();
        if(sampige > "0") {
            $('.error-rooms').text('');
        }
        else if (sampige === "0"){

        }

    });


    $('#parijatha').on('change',function(){
        var parijatha = $("#parijatha option:selected").val();
        if(parijatha > "0") {
            $('.error-rooms').text('');
        }
    else if (parijatha == "0"){

        }
    });


    //validation for radio buttons

    $(function() {
        var $divs = $('#selectOpt > div');
//        $divs.first().show()
        $('input[type=radio]').on('change',function() {
            $divs.hide();
            $divs.eq( $('input[type=radio]').index( this ) ).show();
            $('#pls-select').text('');

        });



    });
    $(document).ready(function() {
        $('#selectfamily').hide();
        $('#selectcorp').hide();



    });
    ////////////////




$('#booknow').click(function () {


    var arrivalDateInput = document.getElementById("arrivalDate");
    var departureDateInput = document.getElementById("departureDate");
    //get no of persons to stay
    var isCouple = document.getElementById('isCouple');
    var isfamilyAdult = document.getElementById('isfamilyAdult');
    var isCoupleKids = document.getElementById('isCoupleKids');

    var isCorp = document.getElementById('isCorp');
    var isCorpkids = document.getElementById('isCorpkids');

    //get get cottages

    var mallige = document.getElementById("mallige");
    var sampige = document.getElementById("sampige");
    var parijatha = document.getElementById("parijatha");


    //store data
    localStorage.setItem("arrivalDateInput", arrivalDateInput.value);
    localStorage.setItem("departureDateInput", departureDateInput.value);

    localStorage.setItem("isCouple", isCouple.value);
    localStorage.setItem("isfamilyAdult", isfamilyAdult.value);
    localStorage.setItem("isCoupleKids", isCoupleKids.value);

    localStorage.setItem("isCorp", isCorp.value);
    localStorage.setItem("isCorpkids", isCorpkids.value);


    localStorage.setItem("mallige", mallige.value);
    localStorage.setItem("sampige", sampige.value);
    localStorage.setItem("parijatha", parijatha.value);

//validation after click

    var checkcouple = localStorage.getItem('isCouple');
    var checkcoupleadult = localStorage.getItem('isfamilyAdult');
    var checkcouplekids = localStorage.getItem('isCoupleKids');

    var checkcorp = localStorage.getItem('isCorp');

    var checkkids = localStorage.getItem('isCorpkids');


    var checkmallige =  localStorage.getItem('mallige');
    var checksampige =  localStorage.getItem('sampige');
    var checkparijatha =  localStorage.getItem('parijatha');

    var fromDate1 = $('#arrivalDate').val(),
        toDate1 = $('#departureDate').val(),
        from1, to1;

    from1 = moment(fromDate1, 'DD-MM-YYYY'); // format in which you have the date
    to1 = moment(toDate1, 'DD-MM-YYYY');

    var checkdatebetween = to1.diff(from1, 'days');



var couple = parseInt(checkcouple) * 2;


var totalmembers = parseInt(checkcorp) + parseInt(checkkids) + parseInt(couple) + parseInt(checkcoupleadult) + parseInt(checkcouplekids);


var totalmembersby5 = totalmembers/5;
    console.log('divide by 5');
    console.log(totalmembersby5);

var finalmembersround = Math.ceil(totalmembersby5);

console.log(finalmembersround);

var totalcottages =  parseInt(checkmallige) +  parseInt(checksampige) +  parseInt(checkparijatha);
    console.log(totalcottages);




    if (checkcorp == 0 && checkcouple == 0 ) {

        alert('Please fill all the required fields');
        $('#myform1').invalid();
    }

    if (checkcorp == 1 ) {

        alert('Atleast 2 Peoples Required for booking');
        $('#myform1').invalid();
    }
    else if(totalcottages == 0){
        alert('Please Select Cottages to Continue');
        $('#errormsg').text('If No cottages available Please contact to 7338000666 / 7338000666');
        $('#myform1').invalid();
    }
    else if(checkmallige == 0 && checksampige ==0 && checkparijatha == 0){
        alert('Please select' +' ' + finalmembersround + ' ' + 'cottage to continue ');
        $('#myform1').invalid();
    }

    else if(finalmembersround != totalcottages)
    {
        alert('Please select  '+ ' ' + finalmembersround + ' ' +'cottages in mallige or sampige  to continue');

        $('#myform1').invalid();
    }
    else if( checkdatebetween <= 0  ){
        alert('Please select correct date to continue');

        $('#departureDate').focus();
        $('#myform1').invalid();
    }

    else {
        //show data in last tab
        document.getElementById("checkindis").innerHTML = localStorage.getItem('arrivalDateInput');
        document.getElementById("checkoutdis").innerHTML = localStorage.getItem('departureDateInput');
        document.getElementById("coupledis").innerHTML = localStorage.getItem('isCouple');

        document.getElementById("coupleadultdis").innerHTML = localStorage.getItem('isfamilyAdult');
        document.getElementById("couplekidsdis").innerHTML = localStorage.getItem('isCoupleKids');
        document.getElementById("corpdis").innerHTML = localStorage.getItem('isCorp');

        document.getElementById("corpkidsdis").innerHTML = localStorage.getItem('isCorpkids');

        document.getElementById("cottagetypemalli").innerHTML = localStorage.getItem('mallige');
        document.getElementById("cottagetypesampi").innerHTML = localStorage.getItem('sampige');
        document.getElementById("cottagetypepari").innerHTML = localStorage.getItem('parijatha');

         //for  hidden field
        document.getElementById("finalArrvial").value = localStorage.getItem('arrivalDateInput');
        document.getElementById("finalDeparture").value = localStorage.getItem('departureDateInput');
        document.getElementById("finalCouples").value = localStorage.getItem('isCouple');
        document.getElementById("finalCoupleAdults").value = localStorage.getItem('isfamilyAdult');
        document.getElementById("finalCoupleKids").value = localStorage.getItem('isCoupleKids');
        document.getElementById("finalCorporate").value = localStorage.getItem('isCorp');
        document.getElementById("finalCorporateKids").value = localStorage.getItem('isCorpkids');


        bookingDetails.ArrivalDate = localStorage.getItem('arrivalDateInput');
        bookingDetails.DepartureDate = localStorage.getItem('departureDateInput');
        bookingDetails.Couple = localStorage.getItem('isCouple');
        bookingDetails.AdultsWithCouple = localStorage.getItem('isfamilyAdult');
        bookingDetails.KidsWithCouple = localStorage.getItem('isCoupleKids');
        bookingDetails.CorporateStags = localStorage.getItem('isCorp');
        bookingDetails.KidsWithCorporateStags = localStorage.getItem('isCorpkids');

        bookingDetails.CottageTypeSampige =localStorage.getItem('sampige')
        bookingDetails.CottageTypeparijatha = localStorage.getItem('parijatha');
        bookingDetails.CottageTypeMallige = localStorage.getItem('mallige');

        var fromDate = $('#arrivalDate').val(),
            toDate = $('#departureDate').val(),
            from, to, duration;

        from = moment(fromDate, 'DD-MM-YYYY'); // format in which you have the date
        to = moment(toDate, 'DD-MM-YYYY');     // format in which you have the date

        /* using diff */
        duration = to.diff(from, 'days');
        localStorage.setItem("duration", duration);
        document.getElementById("durationdis").innerHTML = localStorage.getItem('duration');

        document.getElementById("finalDays").value = localStorage.getItem('duration');

        bookingDetails.Duration = localStorage.getItem('duration');


        var Cp = localStorage.getItem('isCouple');
        var CpCst = bookingDetails.CostForCouple;

        var cpadults = localStorage.getItem('isfamilyAdult');
        var cpadultscost = bookingDetails.CostForAdultsWithCouple;

        var cpkids = localStorage.getItem('isCoupleKids');
        var cpkidscost = bookingDetails.CostForKidsWithCouple;

        var Cr = localStorage.getItem('isCorp');
        var CrCst = bookingDetails.CostForCorporateStags;

        var Kd = localStorage.getItem('isCorpkids');
        var KdCst = bookingDetails.CostForKidsWithCorporateStags;

        var dur = localStorage.getItem('duration');

        //        var numOfDays = days_between(bookingDetails.ArrivalDate, bookingDetails.DepartureDate);

        var total = dur * ( (Cp * CpCst) + (cpadults * cpadultscost) + (cpkids * cpkidscost) + (Cr * CrCst) + (Kd * KdCst));
        console.log(total);
        localStorage.setItem("total", total);
        bookingDetails.Total = localStorage.getItem('total');
        document.getElementById("totaldis").innerHTML = localStorage.getItem('total');
        document.getElementById("finalPrice").value = localStorage.getItem('total');


        var id = 'MB' + Math.round(Math.abs(new Date().getTime()) + dur);

        console.log(id);
        localStorage.setItem("id", id);
        document.getElementById("id").value = localStorage.getItem('id');
        bookingDetails.id = localStorage.getItem('id');


        localStorage.setItem("price", JSON.stringify(bookingDetails));


        var booking_details = localStorage.getItem('price');

        booking_details = JSON.parse(booking_details);
        console.log(booking_details);

       //console.log('am');

        $.ajax({
            type: 'post',
            url: 'visitor.php',
            data: booking_details,

            success: function (data) {
                console.log('i am success');

            }

        });
    }






});




    //over











</script>
</html>

