<?php
require('includes/config.php');

$student_inner_page = true;

//include header template
require('layout/admin-header.php');

//if not logged in redirect to login page
if (!$admin->is_logged_in()) {
    header('Location: admin-login.php');
    exit;
}


$sid = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

$form_action = $sid ? 'update' : 'create';

$current_cottage = [
    'id' => '',
    'cottageName' => '',
    'available' => ''
];


if ($sid) {
    $current_cottage = $availableCottage->getSingle($sid);
}


/* * *********************** */
$current_action = filter_input(INPUT_GET, 'action', FILTER_SANITIZE_STRING);
//saving new book

if ($current_action == 'create') {
    $data = $_POST;
//var_dump($_POST);
    if (isset($_POST['cottageName']) && isset($_POST['available'])) {

        if ($availableCottage->add($data)) {
            header('Location:available-cottage.php');
            exit;
        }

        $current_cottage = $data;
    }
}
else if ($current_action == 'update') {

    $data = $_POST;

    $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);

    if (isset($_POST['cottageName']) && isset($_POST['available'])) {
        if ($availableCottage->update($data, $id)) {
            header('Location:available-cottage.php');
            exit;
        }

        $current_cottage = $data;
    }
} else if ($current_action == 'delete') {

    $id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

    if ($id) {
        $availableCottage->delete($id);
        header('Location:available-cottage.php?d=1');
        exit;
    }
}

/* * *********************** */
?>
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.6.3/css/font-awesome.min.css" rel="stylesheet"
      integrity="sha384-T8Gy5hrqNKT+hzMclPo118YTQO6cYprQmhrYwIiQ/3axmI1hQomh7Ud2hPOy8SP1" crossorigin="anonymous">
<style>
    .fl-rt {
        float: right;
    }
    .btn-warning.fl-rt {
        color: #fff;
        background-color: #9e9d24;
        border-color: #9e9d24;
    }

    .save.margin-top {
        margin-top: 94px;
    }
    .error{
        color: red;
    }
</style>
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <h2> Cottage Details
                <a href="available-cottage.php">
                    <button class="btn btn-warning fl-rt"><span class="fa fa-backward "></span> Go Back</button>
                </a>
            </h2>

            <hr/>
            <div class="col-lg-12">
                <form class="form" method="post"
                      action="<?php echo $_SERVER['PHP_SELF'] . "?action=" . $form_action; ?>"
                      enctype="multipart/form-data">
                    <input value="<?php echo $current_cottage['id'] ?>" type="hidden" name="id"/>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Cottage Name</label>
                            <input value="<?php echo $current_cottage['cottageName'] ?>" class="form-control" type="text"
                                   name="cottageName"/>
                            <p class="error">*Warning: Please Dont make changes to Name</p>
                        </div>

                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Number Of cottages Available</label>
                            <input value="<?php echo $current_cottage['available'] ?>" required class="form-control"
                                   type="text" name="available"/>
                        </div>

                    </div>


                    <div class="col-md-12 text-center">
                        <div class="btn-group ">
                            <button class="btn btn-lg btn-success save margin-top " type="submit"> Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>