<?php

include('password.php');

class User extends Password {

    private $_db;

    function __construct($db) {
        parent::__construct();

        $this->_db = $db;
    }

    private function get_user_hash($username) {

        try {
            $stmt = $this->_db->prepare('SELECT password, username, memberID FROM members WHERE username = :username ');
            $stmt->execute(array('username' => $username));

            return $stmt->fetch();
        } catch (PDOException $e) {
            echo '<p class="bg-danger">' . $e->getMessage() . '</p>';
        }
    }

    public function login($username, $password) {

        $row = $this->get_user_hash($username);

        if ($this->password_verify($password, $row['password']) == 1) {

            $_SESSION['loggedin'] = true;
            $_SESSION['username'] = $row['username'];
            $_SESSION['memberID'] = $row['memberID'];
            return true;
        }
    }

    public function logout() {
        unset($_SESSION);
        session_destroy();
    }

    public function is_logged_in() {
        if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] == true) {
            return true;
        }
        return false;
    }

    public function getCurrentUser() {
        if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] == true) {

            return $_SESSION;
        }
        return false;
    }

    public function getData($user_id) {
        try {

            $query = 'SELECT username from members where memberID = :memberID';

            $stmt = $this->_db->prepare($query);

            $stmt->execute(array(':memberID' => $user_id));

            return $stmt->fetch(PDO::FETCH_ASSOC);
        } catch (PDOException $ex) {
            die($ex);
        }
    }

    public function updatePassword($current_password, $new_password) {

        $userData = $this->getCurrentUser();

        $existing = $this->get_user_hash($userData['username']);

        if ($this->password_verify($current_password, $existing['password']) == 1) {

            $new_password_hash = $this->password_hash($new_password, PASSWORD_BCRYPT);

            try {

                $query = "UPDATE members SET password = :password WHERE memberID = :memberID";

                $stmt = $this->_db->prepare($query);

                $stmt->execute([':password' => $new_password_hash, ':memberID' => $existing['memberID']]);

                return true;
            } catch (Exception $ex) {

                error_log($ex->getTraceAsString());

                return false;
            }

            return false;
        }

        return false;
    }

}

?>
