<?php
/**
 * Created by PhpStorm.
 * User: dev
 * Date: 08/09/18
 * Time: 10:12 AM
 */


class Visitor
{
    var $db;

    public function __construct($db)
    {
        $this->db = $db;
    }

    public function listAllAdmissions()
    {

        try {

            $stmt = $this->db->prepare('SELECT pre_booking_details.id , pre_booking_details.checkin ,pre_booking_details.checkout ,pre_booking_details.no_of_days ,pre_booking_details.couples ,pre_booking_details.adults_with_couple ,pre_booking_details.kids_with_couple ,pre_booking_details.corporate_stags ,pre_booking_details.kids_corporate , pre_booking_details.mallige , pre_booking_details.sampige ,pre_booking_details.parijatha ,pre_booking_details.total_amount, instamojo.id , instamojo.pre_booking_id ,instamojo.payment_id ,instamojo.name ,instamojo.email  ,instamojo.phone ,instamojo.amount_paid ,instamojo.status ,instamojo.payment_date FROM pre_booking_details  INNER JOIN instamojo on pre_booking_details.id = instamojo.pre_booking_id;');

            $stmt->execute();

            return $stmt->fetchAll(PDO::FETCH_ASSOC);

        } catch (PDOException $e) {

            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';
        }
    }




    public function listAllContact($fields = '*')
    {

        try {

            $stmt = $this->db->prepare('SELECT  ' . $fields . ' FROM callback');

            $stmt->execute();

            return $stmt->fetchAll(PDO::FETCH_ASSOC);

        } catch (PDOException $e) {

            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';
        }
    }

    /* admin methods */

    private function adminCheck()
    {
        return isset($_SESSION['isAdmin']) && (@$_SESSION['isAdmin']);
    }

    public function add($data)
    {


//             var_dump($data);exit();
            try {

                $query = 'INSERT 
                          INTO `pre_booking_details` (id, checkin, checkout, no_of_days, couples, adults_with_couple, kids_with_couple,  corporate_stags, kids_corporate, mallige, sampige, parijatha, total_amount) 
                          VALUES (:id ,:checkin, :checkout, :no_of_days, :couple, :couple_adults, :couple_kids,  :corporate_stags, :corporate_kids, :mallige, :sampige, :parijatha, :total_amount)';

//                var_dump($query);
                $stmt = $this->db->prepare($query);

                $stmt->execute(
                    [
                    ':id' => $data['id'],
                    ':checkin' => $data['checkin'],
                    ':checkout' => $data['checkout'],
                    ':no_of_days' => $data['no_of_days'],
                    ':couple' => $data['couple'],
                    ':couple_adults' => $data['couple_adults'],
                    ':couple_kids' => $data['couple_kids'],
                    ':corporate_stags' => $data['corporate_stags'],
                    ':corporate_kids' => $data['corporate_kids'],
                    ':mallige' => $data['mallige'],
                    ':sampige' => $data['sampige'],
                    ':parijatha' => $data['parijatha'],
                    ':total_amount' => $data['total_amount']
                ]);
//                var_dump($stmt);


                return $this->db->lastInsertId();

            } catch (PDOException $exc) {
                print_r($exc->getMessage());
                return false;
            }


        header('location:index.php');
    }

    public function addPayment($booking_details)

        {
//             var_dump($data);exit();
            try {




                $query = 'INSERT INTO instamojo(pre_booking_id, payment_id, name, email, phone, amount_paid, status) VALUES(:pre_id , :payment_id, :name ,:email, :phone , :amount , :status)';


                $stmt = $this->db->prepare($query);

                $stmt->execute([
                    ':pre_id' => $booking_details['pre_booking_id'],
                    ':payment_id' => $booking_details['payment_id'],
                    ':name' => $booking_details['name'],
                    ':email' => $booking_details['email'],
                    ':phone' => $booking_details['phone'],
                    ':amount' => $booking_details['amount'],
                    ':status' =>  $booking_details['status']


                ]);


                return true;


            } catch (PDOException $exc)
            {
                print_r($exc->getMessage());
                return false;
            }





    }




    public function update()
    {

        try {
            $stmt = $this->db->prepare('SELECT pre_booking_details.id , pre_booking_details.mallige , pre_booking_details.sampige ,pre_booking_details.parijatha ,instamojo.pre_booking_id FROM pre_booking_details  INNER JOIN instamojo on pre_booking_details.id = instamojo.pre_booking_id;');

            $stmt->execute();

     $require = $stmt->fetchAll(PDO::FETCH_ASSOC);

     $mallige = $require['mallige'];
     $sampige = $require['sampige'];
     $parijatha = $require['parijatha'];


            $fetchavailable = $this->db->prepare('SELECT available from available_cottages');
            $fetchavailable->execute();



            $allrequirecottage = $fetchavailable->fetchAll(PDO::FETCH_ASSOC);

            $requirecottage = end($allrequirecottage);
           $updatemallige = (int)$requirecottage[0] - (int)$mallige;
           $updatesampige = (int)$requirecottage[1] - (int)$sampige;
           $updateparijatha = (int)$requirecottage[2] - (int)$parijatha;


            $query = 'UPDATE available_cottages SET 
                        (:$updatemallige, :price)';

            $requirecottage = $this->db->prepare($query);

            $requirecottage->execute([
                ':$updatemallige' => $updatemallige,
                ':$updatesampige' => $updatesampige,
                ':$updateparijatha' => $updateparijatha
            ]);
        }



        catch (PDOException $exc) {
            die($exc);
            return false;
        }
    }

    public function delete($book_id = 0)
    {

        $review = [];

        try {
            $query = 'DELETE FROM books WHERE id = :id';

            $stmt = $this->db->prepare($query);

            $delete = $stmt->execute(array("id" => $book_id));
        } catch (Exception $ex) {

        }


        return $delete;
    }



//    public function getStudentByEno($enrollment_no = '', $showError = true)
//    {
//        try {
//
//            $query = 'SELECT *  FROM students WHERE enrollment_no = :enrollment_no';
//
//            $stmt = $this->db->prepare($query);
//
//            $stmt->execute(array("enrollment_no" => $enrollment_no));
//
//            $student = $stmt->fetch(PDO::FETCH_ASSOC);
//
//            return ($student);
//
//        } catch (PDOException $e) {
//
//            if($showError){
//
//                echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';
//
//            }
//
//            return (false);
//        }
//    }

}
