<?php

Class Book {

    var $db;

    public function __construct($db) {
        $this->db = $db;
    }

    public function listAll() {

        try {

            $stmt = $this->db->prepare('SELECT * FROM books WHERE released = :released');

            $stmt->execute(array('released' => "YES"));

            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {

            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';
        }
    }

    public function getJsonBookList() {

        try {

            $stmt = $this->db->prepare('SELECT id, author, title as name, path FROM books WHERE released = :released');

            $stmt->execute(array('released' => "YES"));

            $list = $stmt->fetchAll(PDO::FETCH_ASSOC);

            echo json_encode($list);
        } catch (PDOException $e) {

            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';
        }
    }

    public function getSingle($id = 0) {

        try {

            $query = 'SELECT id, author, title as name, path, summary, isbn_no FROM books WHERE released = :released AND id = :id';

            $stmt = $this->db->prepare($query);

            $stmt->execute(array('released' => "YES", "id" => $id));

            $book = $stmt->fetch(PDO::FETCH_ASSOC);

            /**/

            $book['likes'] = $this->getBookLikes($book['id'], true);

            $book['userLiked'] = $this->checkUserLikes($_SESSION['memberID'], $book['id']);

            $book['reviews'] = $this->getReviews($book['id']);

            return ($book);
        } catch (PDOException $e) {

            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';

            return (false);
        }
    }

    public function getBookPreview($id) {

        $book = $this->getSingle($id);

        if (!$book) {
            echo '<div class="alert alert-danger"> Invalid book id </div>';
            return;
        }

        echo $path = __DIR__ . '/../' . $book['path'] . '[0]';

        $im = new imagick($path);
        $im->setImageFormat('jpg');
        header('Content-Type: image/jpeg');
        echo $im;
    }

    public function userLikesBook($book_id, $user_id, $status) {

        if ($book_id && $user_id && $status) {

            if ($status == 'like') {

                $this->likeBook($book_id, $user_id);
            } else if ($status == 'unlike') {

                $this->unlikeBook($book_id, $user_id);
            }
        }

        return $this->getBookLikes($book_id);
    }

    public function getBookLikes($book_id, $return = false) {

        $stmt = $this->db->prepare('SELECT count(like_id) as likes FROM likes WHERE book_id = :book_id');

        $stmt->execute(array(':book_id' => $book_id));

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($return) {
            return $row['likes'];
        }
        echo json_encode($row);
    }

    public function checkUserLikes($user_id, $book_id) {

        $stmt = $this->db->prepare('SELECT like_id FROM likes WHERE book_id = :book_id AND user_id = :user_id');

        $stmt->execute(array(':book_id' => $book_id, ':user_id' => $user_id));

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        return boolval($row);
    }

    public function getReviews($book_id = 0) {

        $review = [];

        $query = 'SELECT review_id, review_title, review_detail, user_id FROM review WHERE book_id = :book_id';

        $stmt = $this->db->prepare($query);

        $stmt->execute(array("book_id" => $book_id));

        $review = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($review) {
            foreach ($review as $k => $user_review) {
                $review[$k]['user'] = $this->getUserData($user_review['user_id']);
            }
        }

        return $review;
    }

    public function addReview($data) {

        extract($data);

        try {

            $query = 'INSERT INTO review (book_id,user_id, review_title, review_detail) VALUES (:book_id, :user_id, :review_title, :review_detail)';

            $stmt = $this->db->prepare($query);

            $stmt->execute(
                    array(
                        ':book_id' => $book_id,
                        ':user_id' => $user_id,
                        ':review_title' => $review_title,
                        ':review_detail' => $review_detail
                    )
            );

            return $this->db->lastInsertId();
        } catch (PDOException $exc) {
            return false;
        }
    }

    public function updateReview($data, $review_id) {

        try {
            echo $query = 'UPDATE review SET review_title = :review_title, review_detail = :review_detail WHERE review_id = :review_id';

            $stmt = $this->db->prepare($query);

            $stmt->execute(array(':review_title' => $data['review_title'], ':review_detail' => $data['review_detail'], ':review_id' => $review_id));

            return true;
        } catch (PDOException $exc) {
            die($exc);
            return false;
        }
    }

    private function likeBook($book_id, $user_id) {

        $this->unlikeBook($book_id, $user_id);

        $query = 'INSERT INTO likes (book_id,user_id) VALUES (:book_id, :user_id)';

        $stmt = $this->db->prepare($query);

        $stmt->execute(array(
            ':book_id' => $book_id,
            ':user_id' => $user_id
        ));

        $id = $this->db->lastInsertId('like_id');

        return;
    }

    private function unlikeBook($book_id, $user_id) {

        $query = 'DELETE FROM likes WHERE book_id=:book_id AND user_id=:user_id';

        $stmt = $this->db->prepare($query);

        $stmt->execute(array(
            ':book_id' => $book_id,
            ':user_id' => $user_id
        ));

        return;
    }

    private function getUserData($user_id) {

        $user = new User($this->db);

        return ($user->getData($user_id));
    }

   

}

?>