<?php
/**
 * Created by PhpStorm.
 * User: dev
 * Date: 08/09/18
 * Time: 10:12 AM
 */

class PriceList
{
    var $db;

    public function __construct($db)
    {
        $this->db = $db;
    }


    public function listAll($fields = '*')
    {

        try {

            $stmt = $this->db->prepare('SELECT  ' . $fields . ' FROM price_list');

            $stmt->execute();

            return $stmt->fetchAll(PDO::FETCH_ASSOC);

        } catch (PDOException $e) {

            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';
        }
    }

    public function listAllContact($fields = '*')
    {

        try {

            $stmt = $this->db->prepare('SELECT  ' . $fields . ' FROM callback');

            $stmt->execute();

            return $stmt->fetchAll(PDO::FETCH_ASSOC);

        } catch (PDOException $e) {

            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';
        }
    }

    /* admin methods */

    private function adminCheck()
    {
        return isset($_SESSION['isAdmin']) && (@$_SESSION['isAdmin']);
    }

    public function add($data)
    {

        if ($this->adminCheck()) {

            

            try {

                $query = 'INSERT 
                          INTO `price_list` (visitors_type, price) 
                          VALUES (:visitors_type, :price)';

                $stmt = $this->db->prepare($query);

                $stmt->execute([
                    ':visitors_type' => $data['visitors_type'],
                    ':price' => $data['price']
                ]);

                return $this->db->lastInsertId();
            } catch (PDOException $exc) {
                var_dump($exc);
                return false;
            }
        }

        header('location:admin-login.php');
    }

    public function update($data, $student_id)
    {

        try {
            echo $query = 'UPDATE price_list SET visitors_type=:visitors_type, price=:price WHERE id= :id';

            $stmt = $this->db->prepare($query);

            $stmt->execute([
                ':visitors_type' => $data['visitors_type'],
                ':price' => $data['price'],
                ':id' => $student_id

            ]);

            return true;
        } catch (PDOException $exc) {
            die($exc);
            return false;
        }
    }

    public function delete($book_id = 0)
    {

        $review = [];

        try {
            $query = 'DELETE FROM price_list WHERE id = :id';

            $stmt = $this->db->prepare($query);

            $delete = $stmt->execute(array("id" => $book_id));
        } catch (Exception $ex) {

        }


        return $delete;
    }

    public function getSingle($id = 0)
    {

        try {

            $query = 'SELECT *  FROM price_list WHERE id = :id';

            $stmt = $this->db->prepare($query);

            $stmt->execute(array("id" => $id));

            $student = $stmt->fetch(PDO::FETCH_ASSOC);

            return ($student);
        } catch (PDOException $e) {

            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';

            return (false);
        }
    }

    public function getStudentByEno($enrollment_no = '', $showError = true)
    {
        try {

            $query = 'SELECT *  FROM students WHERE enrollment_no = :enrollment_no';

            $stmt = $this->db->prepare($query);

            $stmt->execute(array("enrollment_no" => $enrollment_no));

            $student = $stmt->fetch(PDO::FETCH_ASSOC);

            return ($student);

        } catch (PDOException $e) {

            if($showError){

                echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';

            }

            return (false);
        }
    }


//    public function listAllAdmissions($fields = '*')
//    {
//
//        try {
//
//            $stmt = $this->db->prepare('SELECT  ' . $fields . ' FROM Admission_details');
//
//            $stmt->execute();
//
//            return $stmt->fetchAll(PDO::FETCH_ASSOC);
//
//        } catch (PDOException $e) {
//
//            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';
//        }
//    }

}