<?php
class Userslist
{
    var $db;

    public function __construct($db)
    {
        $this->db = $db;
    }
    public function listAllUsers($fields = '*')
    {

        try {

            $stmt = $this->db->prepare('SELECT  ' . $fields . ' FROM user_details ORDER BY Id DESC');

            $stmt->execute();

            return $stmt->fetchAll(PDO::FETCH_ASSOC);

        } catch (PDOException $e) {

            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';
        }
    }

    public function listAll($fields = '*')
    {

        try {

            $stmt = $this->db->prepare('SELECT  ' . $fields . ' FROM students');

            $stmt->execute();

            return $stmt->fetchAll(PDO::FETCH_ASSOC);

        } catch (PDOException $e) {

            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';
        }
    }

    public function listAllContact($fields = '*')
    {

        try {

            $stmt = $this->db->prepare('SELECT  ' . $fields . ' FROM callback');

            $stmt->execute();

            return $stmt->fetchAll(PDO::FETCH_ASSOC);

        } catch (PDOException $e) {

            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';
        }
    }

    /* admin methods */

    private function adminCheck()
    {
        return isset($_SESSION['isAdmin']) && (@$_SESSION['isAdmin']);
    }

    public function add($data)
    {
        // var_dump($data);exit();
        try {

            $query = 'INSERT 
                          INTO `user_details` (Name, Phone, Email, Message) 
                          VALUES ( :Name, :Phone, :Email, :Message)';

            $stmt = $this->db->prepare($query);

            $stmt->execute([
                ':Name' => $data['Name'],
                ':Phone' => $data['Phone'],
                ':Email' => $data['Email'],
                ':Message' => $data['Messgae']
            ]);


            return $this->db->lastInsertId();
        } catch (PDOException $exc) {
            var_dump($exc);
            return false;
        }


        header('location:index.php');
    }

//    public function update($booking_id, $id)
//    {
//
//        try {
//            $query = 'UPDATE user_details SET booking_id=:booking_id WHERE id= :id';
//
//            $stmt = $this->db->prepare($query);
//
//            $stmt->execute([
//                ':booking_id' => $booking_id,
//                ':id' => $id
//            ]);
//
//            return true;
//        } catch (PDOException $exc) {
//            die($exc);
//            return false;
//        }
//    }
//
//    public function delete($book_id = 0)
//    {
//
//        $review = [];
//
//        try {
//            $query = 'DELETE FROM books WHERE id = :id';
//
//            $stmt = $this->db->prepare($query);
//
//            $delete = $stmt->execute(array("id" => $book_id));
//        } catch (Exception $ex) {
//
//        }
//
//
//        return $delete;
//    }

    public function getSingle($id = 0)
    {

        try {

            $query = 'SELECT *  FROM students WHERE id = :id';

            $stmt = $this->db->prepare($query);

            $stmt->execute(array("id" => $id));

            $student = $stmt->fetch(PDO::FETCH_ASSOC);

            return ($student);
        } catch (PDOException $e) {

            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';

            return (false);
        }
    }

    public function getStudentByEno($enrollment_no = '', $showError = true)
    {
        try {

            $query = 'SELECT *  FROM students WHERE enrollment_no = :enrollment_no';

            $stmt = $this->db->prepare($query);

            $stmt->execute(array("enrollment_no" => $enrollment_no));

            $student = $stmt->fetch(PDO::FETCH_ASSOC);

            return ($student);

        } catch (PDOException $e) {

            if($showError){

                echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';

            }

            return (false);
        }
    }

}
