<?php
/**
 * Created by PhpStorm.
 * User: dev
 * Date: 08/09/18
 * Time: 10:12 AM
 */

class AvailableCottages
{
    var $db;

    public function __construct($db)
    {
        $this->db = $db;
    }

    /* admin methods */

    private function adminCheck()
    {
        return isset($_SESSION['isAdmin']) && (@$_SESSION['isAdmin']);
    }

    public function add($data)
    {

        if ($this->adminCheck()) {



            try {

                $query = 'INSERT 
                          INTO `available_cottages` (cottageName, available) 
                          VALUES (:cottageName, :available)';

                $stmt = $this->db->prepare($query);

                $stmt->execute([
                    ':cottageName' => $data['cottageName'],
                    ':available' => $data['available']
                ]);

                return $this->db->lastInsertId();
            } catch (PDOException $exc) {
                var_dump($exc);
                return false;
            }
        }

        header('location:admin-login.php');
    }

    public function getSingle($id = 0)
    {

        try {

            $query = 'SELECT *  FROM available_cottages WHERE id = :id';

            $stmt = $this->db->prepare($query);

            $stmt->execute(array("id" => $id));

            $cottage = $stmt->fetch(PDO::FETCH_ASSOC);

            return ($cottage);
        } catch (PDOException $e) {

            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';

            return (false);
        }
    }

    public function update($data, $id)
    {


        try {
            echo $query = 'UPDATE available_cottages SET cottageName=:cottageName, available=:available WHERE id= :id';

            $stmt = $this->db->prepare($query);

            $stmt->execute([
                ':cottageName' => $data['cottageName'],
                ':available' => $data['available'],
                ':id' => $id

            ]);

            return true;
        } catch (PDOException $exc) {
            die($exc);
            return false;
        }
    }

    public function delete($id = 0)
    {

        $review = [];

        try {
            $query = 'DELETE FROM available_cottages WHERE id = :id';

            $stmt = $this->db->prepare($query);

            $delete = $stmt->execute(array("id" => $id));
        } catch (Exception $ex) {

        }


        return $delete;
    }


    public function listAll($fields = '*')
    {

        try {

            $stmt = $this->db->prepare('SELECT  ' . $fields . ' FROM available_cottages');

            $stmt->execute();

            return $stmt->fetchAll(PDO::FETCH_ASSOC);

        } catch (PDOException $e) {

            echo '<div class="alert alert-danger">' . $e->getMessage() . '</div>';
        }
    }



}