<?php

class Admin
{

    private $_db;

    function __construct($db)
    {
        $this->_db = $db;
    }

    public function login($username, $password)
    {

        if ($username == ADMIN_USER_NAME) {
            if ($password == ADMIN_PASSWORD) {

                $_SESSION['isAdmin'] = true;
                $_SESSION['username'] = 'Admin';
                return true;
            }
        }

        return false;
    }

    public function logout()
    {
        unset($_SESSION);
        session_destroy();
    }

    public function is_logged_in()
    {
        if (isset($_SESSION['isAdmin']) && $_SESSION['isAdmin'] == true) {
            return true;
        }
        return false;
    }

    public function bookDetailValidate()
    {

        $_data = $_POST;

        $bookData = [
            'path' => FALSE, 'title' => FALSE, 'isbn_no' => FALSE, 'author' => FALSE, 'summary' => FALSE
        ];

        foreach ($_data as $key => $_item) {
            if ($key !== 'b_id')
                $bookData[substr($key, 2)] = filter_var($_item);
        }

        if (!$bookData['path'] || isset($_FILES['b_path'])) {
            $bookData['path'] = $this->uploadBook($_FILES['b_path'], $_data['b_path']);
        }

        return $bookData;
    }

    public function uploadBook($file, $old_path)
    {

        if ($file['error'] == 0 || $file['error'] == '0') {

            try {

                $fileName = uniqid() . '_' . $file['name'];

                if (move_uploaded_file($file['tmp_name'], __DIR__ . '/../pdfs/' . $fileName)) {

                    @unlink(__DIR__ . '/../' . $old_path);

                    return 'pdfs/' . $fileName;
                }
            } catch (Exception $ex) {

            }
        }
        return $old_path;
    }

    public function reviewManagement($status, $rid)
    {

        try {
            $query = 'UPDATE review SET approved = :approved WHERE review_id = :review_id';

            $stmt = $this->_db->prepare($query);

            $stmt->execute([':approved' => $status, ':review_id' => $rid]);

            return true;
        } catch (PDOException $exc) {

            return false;
        }
    }

    public function reviewDelete($rid)
    {

        try {
            $query = 'UPDATE review SET deleted = :status WHERE review_id = :review_id';

            $stmt = $this->_db->prepare($query);

            $stmt->execute([':status' => "YES", ':review_id' => $rid]);

            return true;
        } catch (PDOException $exc) {

            return false;
        }
    }

}

?>
