<?php
require('includes/config.php');

$student_inner_page = true;

//include header template
require('layout/admin-header.php');

//if not logged in redirect to login page
if (!$admin->is_logged_in()) {
    header('Location: admin-login.php');
    exit;
}
$students = $student->listAll();

$numRows = 0;
$validRows = 0;
$nonValidRows = 0;

//bulk import excel sheet
require_once 'vendor/box/spout/src/Spout/Autoloader/autoload.php';

use Box\Spout\Reader\ReaderFactory;
use Box\Spout\Common\Type;

function ExcelReading($filePath = ''){

    global $student;
    //Reading the file
// $filePath ="excel-file/Book1.xlsx";

    $fileReader = ReaderFactory::create(Type::XLSX); // for XLSX files

    $fileReader->open($filePath);

    $results = [];

    global $numRows;
    global $validRows;
    global $nonValidRows;

    //counting function
    foreach ($fileReader->getSheetIterator() as $sheet) {

       $m = get_class_methods($sheet->getRowIterator());
       
            foreach ($sheet->getRowIterator() as $i => $row) {


            
                if ($i > 1) {

                $numRows++;

                //check if student enrollment exist
                if (!$student->getStudentByEno($row[2], false)) {
                    //new student counter
                    $nonValidRows++;

//                    var_dump($sheet->getRowIterator());
//
                    $current_student = [
                        'enrollment_no' => $row[2],
                        'course' => $row[4],
                        'name' => $row[1],
                        'father_name' => $row[3],
                        'yoc' => $row[5],
                        'dob' =>$row[6]->format('d/m/Y')
                    ];

                    $student->add($current_student);
                    // header('Location:admin-upload-excel.php');

                    // var_dump('Student not found', $row);
                } else {
                    //duplicate counter

                    $validRows++;
                    // header('Location:admin-upload-excel.php');

                    // var_dump('Student found', $row);
                }
            }

        }break;

    $fileReader->close();
}
// $numRows--;
// var_dump($numRows);
}

if(isset($_POST["submit"])&&$_FILES['file']['name'])
{
//getting user uploaded file

$file=$_FILES["file"];

// var_dump($_FILES['file']['name']);

//saving files in excel-file folder

$status= move_uploaded_file($file["tmp_name"],"excel-file/".$file["name"]);

ExcelReading("excel-file/".$file["name"]);

// var_dump($status);

// exit;

}




?>
<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.6.3/css/font-awesome.min.css" rel="stylesheet"
      integrity="sha384-T8Gy5hrqNKT+hzMclPo118YTQO6cYprQmhrYwIiQ/3axmI1hQomh7Ud2hPOy8SP1" crossorigin="anonymous">
<style>
    .fl-rt {
        float: right;
        margin: 0 5px;
    }
.dld-btn, .dld-btn:hover ,.dld-btn:focus{    border-radius: 25px;
    background-color: #5cb85c;
    box-shadow: 3px 3px 10px #212121;
    color: #ffffff;
outline: none;}
</style>
<a href="admin-home.php">
                    <button class="btn btn-default fl-rt"><span class="fa fa-backward "></span> Go Back</button>
                </a>

<form enctype="multipart/form-data" method="post" action="admin-upload-excel.php">
<div class="clearfix">
    <div class="form-group col-md-6 col-sm-6 col-lg-6">
        <input type="file" class="form-control" name="file" accept=".xls,.xlsx" required>
    </div>
    <div class="form-group col-md-3 col-sm-3 col-lg-3">
      <input type="submit" class="btn dld-btn" name="submit" value="Upload">
    </div>

</div>

<div class = "container">
<p>Total number of rows : <?php echo $numRows; ?></p>
<p>Number of students found : <?php echo $validRows; ?></p>
<p>Number of students not found : <?php echo $nonValidRows; ?></p>
</div>

</form>

<div class="col-md-4 col-sm-4 col-lg-4">
    <embed src="../img/Book1.xlsx" type="application/pdf" height="0" width="0"
           class="responsive">
        <p>*Sample file to upload <a
                    href="../img/Book1.xlsx" target="_blank">
                <button class="btn dld-btn">Download <i class="fa fa-download" aria-hidden="true"></i></button>
            </a></p>
</div>

<script src="js/jquery.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="https://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.18/js/dataTables.bootstrap.min.js"></script>
<script src="js/bootbox.min.js"></script>


</body>
</html