<?php
require('includes/config.php');

$student_inner_page = true;

//include header template
require('layout/admin-header.php');

//if not logged in redirect to login page
if (!$admin->is_logged_in()) {
    header('Location: admin-login.php');
    exit;
}

$sid = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

$form_action = $sid ? 'update' : 'create';

$current_student = [
    'id' => '',
    'name' => '',
    'email' => '',
    'phone' => ''
];


if ($sid) {
    $current_student = $visitor->getSingle($sid);
}


/* * *********************** */
$current_action = filter_input(INPUT_GET, 'action', FILTER_SANITIZE_STRING);
//saving new book

if ($current_action == 'create') {

    $data = $_POST;



    if (isset($_POST['name']) && isset($_POST['phone'])) {

        if ($visitor->add($data)) {
            header('Location:admin-home.php');
            exit;
        }

        $current_student = $data;
    }
} else if ($current_action == 'update') {

    $data = $_POST;

    $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);

    if (isset($_POST['phone']) && isset($_POST['name'])) {

        if ($student->update($data, $id)) {
            header('Location:admin-home.php');
            exit;
        }

        $current_student = $data;
    }
} else if ($current_action == 'delete') {

    $id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

    if ($id) {
        $student->delete($id);
        header('Location:admin-home.php?d=1');
        exit;
    }
}

/* * *********************** */
?>
<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.6.3/css/font-awesome.min.css" rel="stylesheet"
      integrity="sha384-T8Gy5hrqNKT+hzMclPo118YTQO6cYprQmhrYwIiQ/3axmI1hQomh7Ud2hPOy8SP1" crossorigin="anonymous">
<style>
    .fl-rt {
        float: right;
    }

    .save.margin-top {
        margin-top: 94px;
    }
</style>
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <h2> Student Details
                <a href="admin-home.php">
                    <button class="btn btn-default fl-rt"><span class="fa fa-backward "></span> Go Back</button>
                </a>
            </h2>

            <hr/>
            <div class="col-lg-12">
                <form class="form" method="post"
                      action="<?php echo $_SERVER['PHP_SELF'] . "?action=" . $form_action; ?>"
                      enctype="multipart/form-data">
                    <input value="<?php echo $current_student['id'] ?>" type="hidden" name="s_id"/>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Enrollment No</label>
                            <input value="<?php echo $current_student['name'] ?>" required class="form-control" type="text"
                                   name="name"/>
                        </div>
                        <div class="form-group">
                            <label>Course</label>
                            <input value="<?php echo $current_student['email'] ?>" required class="form-control"
                                   type="text" name="email"/>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Name</label>
                            <input value="<?php echo $current_student['name'] ?>" required class="form-control"
                                   type="text" name="name"/>
                        </div>
                        <div class="form-group">
                            <label>Father Name</label>
                            <input value="<?php echo $current_student['father_name'] ?>"
                                   class="form-control" type="text" name="father_name" accept="application/pdf"/>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Year of completion</label>
                            <input value="<?php echo $current_student['yoc'] ?>"
                                   class="form-control" type="text" name="yoc" accept="application/pdf"/>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Date of birth</label>
                            <input value="<?php echo $current_student['dob'] ?>"
                                   class="form-control" type="text" name="dob" accept="application/pdf"/>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="btn-group fl-rt">
                            <button class="btn btn-lg btn-success save margin-top " type="submit"> Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>